/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MathHelper;

public class GameOverStat {
    public final String label;
    public final String value;
    public static final float LABEL_X = 760.0f * Settings.scale;
    private static final float VALUE_X = 1150.0f * Settings.scale;
    public boolean hidden = true;
    private Color color = Settings.CREAM_COLOR.cpy();
    private float offsetX = -50.0f * Settings.scale;
    private boolean line = false;

    public GameOverStat() {
        this.label = null;
        this.value = null;
        this.color.a = 0.0f;
        this.line = true;
    }

    public GameOverStat(String label, String value) {
        this.label = label;
        this.value = value;
        this.color.a = 0.0f;
    }

    public void update() {
        if (!this.hidden) {
            this.color.a = MathHelper.slowColorLerpSnap(this.color.a, 1.0f);
            this.offsetX = MathHelper.uiLerpSnap(this.offsetX, 0.0f);
        }
    }

    public void render(SpriteBatch sb, float y) {
        if (this.line) {
            sb.setColor(this.color);
            sb.draw(ImageMaster.WHITE_SQUARE_IMG, LABEL_X, y - 10.0f * Settings.scale, VALUE_X - LABEL_X, 4.0f * Settings.scale);
            sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
            sb.draw(ImageMaster.WHITE_SQUARE_IMG, LABEL_X, y - 10.0f * Settings.scale, VALUE_X - LABEL_X, 1.0f * Settings.scale);
        } else {
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.topPanelInfoFont, this.label, LABEL_X + this.offsetX, y, this.color);
            FontHelper.renderFontRightTopAligned(sb, FontHelper.topPanelInfoFont, this.value, VALUE_X + this.offsetX, y, this.color);
        }
    }
}

